//+------------------------------------------------------------------+
//|                                                   C_Terminal.mqh |
//|                                                      Daniel Jose |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
class C_Terminal
{
	protected:
//+------------------------------------------------------------------+
		struct stTerminal
		{
			ENUM_SYMBOL_CHART_MODE ChartMode;
			int		nDigits;
			double	VolMinimal,
						VolStep,
						PointPerTick,
						ValuePerPoint,
						AdjustToTrade;
		};
//+------------------------------------------------------------------+
inline double AdjustPrice(const double value)
			{
				return MathRound(value / m_TerminalInfo.PointPerTick) * m_TerminalInfo.PointPerTick;
			}
//+------------------------------------------------------------------+
inline double FinanceToPoints(const double Finance, const uint Leverage)
			{
				double volume = m_TerminalInfo.VolMinimal + (m_TerminalInfo.VolStep * (Leverage - 1));
				
				return AdjustPrice(MathAbs(((Finance / volume) / m_TerminalInfo.AdjustToTrade)));
			};
//+------------------------------------------------------------------+
inline const stTerminal GetTerminalInfos(void) const
			{
				return m_TerminalInfo;
			}
//+------------------------------------------------------------------+
	private	:
		stTerminal m_TerminalInfo;
	public	:
//+------------------------------------------------------------------+
		C_Terminal()
			{
				m_TerminalInfo.nDigits 			= (int)SymbolInfoInteger(_Symbol, SYMBOL_DIGITS);
				m_TerminalInfo.VolMinimal 		= SymbolInfoDouble(_Symbol, SYMBOL_VOLUME_MIN);
				m_TerminalInfo.VolStep	 		= SymbolInfoDouble(_Symbol, SYMBOL_VOLUME_STEP);
				m_TerminalInfo.PointPerTick	= SymbolInfoDouble(_Symbol, SYMBOL_TRADE_TICK_SIZE);
				m_TerminalInfo.ValuePerPoint	= SymbolInfoDouble(_Symbol, SYMBOL_TRADE_TICK_VALUE);
				m_TerminalInfo.AdjustToTrade 	= m_TerminalInfo.ValuePerPoint / m_TerminalInfo.PointPerTick;
				m_TerminalInfo.ChartMode		= (ENUM_SYMBOL_CHART_MODE) SymbolInfoInteger(_Symbol, SYMBOL_CHART_MODE);
			}
//+------------------------------------------------------------------+
};
//+------------------------------------------------------------------+
